#pragma once

#include "CMassView.h"
//	CMassWindow.h
	
class CMassWindow : public BWindow {

private:
	CMassView		*theView;								//	the main view
	BMenuBar		*theMenuBar;							//	the menu bar
public:
	CMassWindow(BRect frame); 								// 	constructor
	virtual	bool	QuitRequested();						//	time to go
	virtual void MessageReceived(BMessage *theEvent);		//	responds to event messages
	private:
	void ResetPlayer(int player, int playerType);			//	reset the player type
	void ResetSpeed(long speedOption);						//	resets the speed
	void ResetPriority(long newPriority);					//	resets the priority
	void ShowAlert(long whichItem);							//	shows an alert for rules, &c.
	}; // end of class CMassWindow

// 	items on Game menu
#define AboutCMItem 				1001L		
#define NewGameItem					1002L
//#define TakeBackItem				1003L
#define QuitItem					1004L

//	items on Player 1 Menu
#define Player1HumanItem			2001L
#define	Player1RandomItem			2002L
#define Player1SmartItem			2003L
#define Player1AIItem				2004L
#define Player1IsBillKocayItem		2005L

//	items on Player 2 Menu
#define Player2HumanItem			3001L
#define	Player2RandomItem			3002L
#define Player2SmartItem			3003L
#define Player2AIItem				3004L
#define Player2IsBillKocayItem		3005L

//	items on Options Menu
#define OptionSoundToggleItem		4001L
//  see CMassView.h for speed options

//	items on Help Menu
#define	HelpGameRulesItem			5001L
#define	HelpMenuOptionsItem			5002L

#define HELP_STUFF_1 "Critical Mass (BeOS)\n\nBy Hamish Carr, 1998.\numcarr@ccu.umanitoba.ca\n\nA BeOS port of a game I wrote for a course\n\nHow does it work?\n\n"
#define HELP_STUFF_2 "Try blowing some stuff up and find out.  Or look at the Help menu for the game rules and options.\n\nSpecial thanks to J. Waschuk (j@intrinsix.ca) for the artwork."
#define HELP_STRING HELP_STUFF_1 HELP_STUFF_2
#define RULES_STUFF_1 "Critical Mass Rules\n\nThe players take turns building atoms by placing protons in the cells shown in the window.  Unfortunately, these atoms are highly unstable.  "
#define RULES_STUFF_2 "When the atom reaches critical mass, it explodes, throwing its protons into adjacent cells.  Each adjacent cell has one proton added, and is converted to the player's "
#define RULES_STUFF_3 " colour.  If the adjacent cell reaches critical mass as a result of the additional proton, it too explodes, in a chain reaction.  "
#define RULES_STUFF_4 "\n\nThe aim of the game is to exploit these chain reactions to wipe out your opponent's atoms."
#define RULES_STUFF_5 "\n\nThe edges of the window are reflective, so atoms at the edge reach critical mass sooner.  Critical mass for any cell is one proton for each of its neighbours."
#define RULES_STUFF_6 "Thus, critical mass in a corner square is 2, critical mass in an edge square is 3, and critical mass in a centre square is 4."
#define RULES_STRING RULES_STUFF_1 RULES_STUFF_2 RULES_STUFF_3 RULES_STUFF_4 RULES_STUFF_5 RULES_STUFF_6
#define MENUS_STUFF_1 "Critical Mass Menus\n\nMost of the menu options are self-explanatory.\n\nThere is a separate player menu for Red & Blue, so that you can play against the computer or "
#define MENUS_STUFF_2 "a friend.  As you go further down the list, the opponents get tougher.  On the Options menu, please remember that using low priority for the brain is recommended."
#define MENU_STRING MENUS_STUFF_1 MENUS_STUFF_2

